<?php

include dirname(__FILE__).'/admin/config.php';

$page_title = "Signup to $site_name";
$meta = "User Registration at $site_name, Signup to $site_name";
include dirname(__FILE__).'/header.php';

?>
  <div class="container">  
		<div class="col-xs-12 col-md-8 col-sm-offset-2">
	<?php
	// We check if the form has been submitted
	if( isset($_POST['confirmation']) && $_POST['confirmation']=='true' ) {
		$name = trim($_POST['name']);
		$email = trim($_POST['email']);
		$messages = array();
		if ( !isset($name) OR empty($name) ){
			$messages['name'] = 'Name cannot be empty.';
		} else if ( strlen($_POST['name'])>55 ){
			$messages['name'] = 'Name is too long. Maximum is 55 characters please.';
		}
		
		if ( !isset($_POST['password']) OR empty($_POST['password']) ){
			$messages['password'] = 'Password cannot be empty.';
		}
		
		if ( !isset($_POST['conf_passwd']) OR empty($_POST['conf_passwd']) ){
			$messages['conf_passwd'] = 'Confirm Password cannot be empty.';
		}
		
		if(!isset($messages['conf_passwd']) && !isset($messages['password'])){
			if(md5($_POST['conf_passwd']) != md5($_POST['password'])){
				$messages['passwd'] = 'Password and Confirm Password must be same.';
			}
		}
		
		if ( !isset($email) OR empty($email) ){
			$messages['email'] = 'Email cannot be empty.';
		} else {
			$regex = '/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/';
			if ( !preg_match($regex, $_POST['email']) ) {
				$messages['email'] = $_POST['email'] . " is an invalid email. Please try again.";
			}
			
		
		}
		
		if ( count($messages) > 0 ){
			display_form($_POST, $messages);
		} 
		else 
		{

			// We get the future ID of the Website
			$table_name = 'Users';
			$users = ORM::for_table($table_name)->find_many();
        	$id = intval(count($users)) + 1;
			$check_users = ORM::for_table($table_name)->where_equal('email_id', $_POST['email'])->find_many();
			if(count($check_users) == 0)
			{
				//reCaptcha code start
			
				if($_SERVER["REQUEST_METHOD"] == "POST")
				{
					$recaptcha=$_POST['g-recaptcha-response'];
					if(!empty($recaptcha))
					{
						include(dirname(__FILE__)."/getCurlData.php");
						$google_url="https://www.google.com/recaptcha/api/siteverify";
						$secret= $captcha_secret;
						$ip=$_SERVER['REMOTE_ADDR'];
						$url=$google_url."?secret=".$secret."&response=".$recaptcha."&remoteip=".$ip;
						$res=getCurlData($url);
						$res= json_decode($res, true);
						//reCaptcha success check 
						if($res['success'])
						{
							///Code here
							
							if($mail) {
								$subject = 'Link account Confirmation';
								$message = "Dear ".$_POST['name'].",
				\t\tYour account is created successfully  on our top site.\n
				You can add your website link and start earning votes by sharing the link on your website.
	
				Thank you";
								$to = $_POST['email'];
								$headers = "From: \"Top site\" <".$mail_webmaster.">\n";
								$headers .= "Cc: ".$mail_webmaster."\n";
								$headers .= "Content-Type: text/plain; charset=\"utf-8\"";
								mail($to, $subject, $message, $headers);
							}
							
							// We protect the variables and we limit the number of letters of some fields
						
							//$query = ORM::get_db()->prepare("INSERT INTO `Users` (user_id, name, email_id, password, status) values (:user_id, :name, :email_id, :password, 0)");
							$query = ORM::get_db()->prepare("INSERT INTO Users ( name, email_id, password, status) values ( :name, :email_id, :password, 0)");
							//$query->bindParam(':user_id', $id, PDO::PARAM_INT);
							$query->bindParam(':name', $_POST['name'], PDO::PARAM_STR);
							$query->bindParam(':email_id', $_POST['email'], PDO::PARAM_STR);
							$query->bindParam(':password', $_POST['password'], PDO::PARAM_STR);
						
							// On ajoute le site a la bdd
							if( $query->execute() ) {
								echo '<div class="alert alert-success" role="alert">Your account has successfully been created.
								<a href="' . $base_url . 'pages/login">Click Here for login</a></div>';
							} else {
								echo '<strong>An error occurred while submitting the data.</strong>';
							}
							$_POST = array();
						}
						else
						{
							$messages['msg'] = "Please re-enter your reCAPTCHA.";
						}
	
					}
					else
					{
						$messages['msg'] =  "Please re-enter your reCAPTCHA.";
						
					}
	
				}
			}
			else
			{
				echo '<div class="alert alert-success" role="alert">You are already registered.
				<a href="' . $base_url . 'pages/login">Click Here for login</a></div>';
				$_POST = array();
			}
			display_form($_POST, $messages);
		}
	} 
	else 
	{
		display_form();
	}

function display_form($data = array(), $errors=array()){
	global $display_form;
	global $captcha_public;
	global $captcha_secret;
	
	if ( isset($display_form) ) return;
	$display_form = true;
	
	//We display the form
	?>
	<?php if (count($errors)): ?>
	<div class="alert alert-danger" role="alert">
		<ol class="text-left" style="margin: 0;">
		<?php foreach ($errors as $n => $m): ?>
			<li><?php echo $m; ?></li>
		<?php endforeach; ?>
		</ol>
	</div>
	<?php else: ?>
	<p class="lead">To add your website to this top site, you have to create account:</p>
	<?php endif; ?>
	
	<form action="" method="post" class="form-horizontal" accept-charset="utf-9">
	
		<div class="form-group<?php if(array_key_exists('name', $errors)) echo ' has-error'; ?>">
			<label class="control-label col-md-3" for="name">Full Name</label>
			<div class="controls col-md-9 col-xs-12">
				<input class="form-control" type="text" name="name" id="name" value="<?php echo isset($data['name']) ? $data['name'] : ''; ?>" required maxlength="55" placeholder="Full Name" />
			</div>
		</div>
		<div class="form-group<?php if(array_key_exists('email', $errors)) echo ' has-error'; ?>">
			<label class="control-label col-md-3" for="url">Email ID</label>
			<div class="controls col-md-9 col-xs-12">
				<input class="form-control" type="text" name="email" id="email" required value="<?php echo isset($data['email']) ? $data['email'] : ''; ?>" placeholder="Email ID"/>
			</div>
		</div>
		<div class="form-group<?php if(array_key_exists('password', $errors) || array_key_exists('passwd', $errors)) echo ' has-error'; ?>">
			<label class="control-label col-md-3" for="description">Password</label>
			<div class="controls col-md-9 col-xs-12">
				<input class="form-control" type="password" name="password" id="password" required value="<?php echo isset($data['password']) ? $data['password'] : ''; ?>" placeholder="Password" />
			</div>
		</div>
		<div class="form-group<?php if(array_key_exists('conf_passwd', $errors) || array_key_exists('passwd', $errors)) echo ' has-error'; ?>">
			<label class="control-label col-md-3" for="banner">Confirm Password</label>
			<div class="controls col-md-9 col-xs-12">
				<input class="form-control" type="password" name="conf_passwd" id="conf_passwd" required value="<?php echo isset($data['conf_passwd']) ? $data['conf_passwd'] : ''; ?>" placeholder="Confirm Password" />
			</div>
		</div>
		<?php 
		if($captcha_public != "" && $captcha_secret != "")
		{
		?>
		<div class="form-group">
			<div class="col-md-9 col-md-offset-3">
				<div class="g-recaptcha" data-sitekey="<?php echo $captcha_public?>"></div>
			</div>
		</div>
		<?php
		}
		?>
		<div class="form-group">
			<div class="col-md-3"><input type="hidden" name="confirmation" value="true" /></div>
			<div class="controls col-md-9 col-xs-12">
				<input type="submit" value="Submit" class="btn btn-success btn-block" />
			</div>
		</div>
	</form>
	<?php
}
?>
    </div></div>
<?php
include dirname(__FILE__).'/footer.php';
?>