<?php
$_themes = array();
foreach ( glob( dirname(__FILE__)."/$design/assets/css/theme/*" ) as $dir ){
	if ( is_dir($dir) ){
		$t = basename($dir);
		$_themes[$t] = ucwords($t);
	}
}
if ( !count($_themes) ){
	$themeswitcher = 'off';
}
if ( isset($_COOKIE['current_theme']) ){
	if ( isset($_themes[$_COOKIE['current_theme']]) ){
		$theme = $_COOKIE['current_theme'];
	}
}
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="keywords" content="<?php echo $meta?>">
	<meta name="description" content="<?php echo $site_description?>">
    
    <link href="<?php echo $base_url.$design; ?>/assets/css/theme/<?php echo $theme; ?>/bootstrap.min.css" rel="stylesheet" id="theme_switcher"/>
    <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css">
    <link href="<?php echo $base_url.$design; ?>/assets/css/app.css" rel="stylesheet" />
    <script type="text/javascript" src="<?php echo $base_url.$design; ?>/assets/js/jquery-2.1.1.min.js"></script>
    <script type="text/javascript" src="<?php echo $base_url.$design; ?>/assets/js/bootstrap.min.js"></script>
    <script type="text/javascript" src="<?php echo $base_url.$design; ?>/assets/js/application.js"></script>	
	<script src='https://www.google.com/recaptcha/api.js'></script>
    <title><?php echo $page_title; ?> - <?php echo $site_slogan; ?></title>

<?php echo $head_code?>
  </head>
  
  <body>
	<nav id="topnav" class="navbar navbar-fixed-top navbar-default" role="navigation">
        <div class="container">
        	<!-- Brand and toggle get grouped for better mobile display -->
			<div class="navbar-header">
                <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-ex1-collapse">
                     <span class="sr-only">Toggle navigation</span>
                      <span class="icon-bar"></span>
                      <span class="icon-bar"></span>
                      <span class="icon-bar"></span>
                </button>
                <a class="navbar-brand" href="<?php echo $base_url; ?>"><i class="fa fa-list-ol"></i> <?php echo $site_name; ?></a>
            </div>

              <!-- Collect the nav links, forms, and other content for toggling -->
            <div class="collapse navbar-collapse navbar-ex1-collapse">
                <ul class="nav navbar-nav">
				<?php 
				if(isset($_SESSION['user_id']) && $_SESSION['user_id'] != "")
				{ ?>
                    <li><a href="<?php echo $base_url?>pages/new"><i class="fa fa-plus"></i> Add Link</a></li>
                    <li><a href="<?php echo $base_url?>pages/displaylink"><i class="fa fa-plus"></i> Links</a></li>
                    <li><a href="<?php echo $base_url?>pages/logout"><i class="fa fa-lock"></i>Logout</a></li>
				<?php
				} 
				else
				{?>
				
                    <li><a href="<?php echo $base_url?>pages/login"><i class="fa fa-unlock"></i>Login</a></li>
                    <li><a href="<?php echo $base_url?>pages/register"><i class="fa fa-user"></i>Register</a></li>
				<?php }?>
                    <li><a href="http://antiref.com/?http://www.scriptgeni.com/software/links-directory/" target="_blank"><i class="fa fa-user"></i>Download Link Directory</a></li>				
                </ul>
                <?php if (isset($themeswitcher) && $themeswitcher=='on'): ?>
                <ul class="nav navbar-nav navbar-right">
                    <li>
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown"><span id="current_theme"><?php echo isset($theme) && isset($_themes[$theme]) ? $_themes[$theme] : 'Default'; ?></span> <b class="caret"></b></a>
                        <ul class="dropdown-menu">
                            <?php foreach ($_themes as $t => $label): ?>
                            <li<?php if(isset($theme) && $theme==$t) echo ' class="active"'; ?>><a data-toggle="theme" href="<?php echo "#$t"; ?>"><?php echo $label; ?></a></li>
                            <?php endforeach; ?>
                        </ul>
                    </li>
                </ul>
                <?php endif; ?>
            </div>
            <!-- /.navbar-collapse -->
        </div>
    </nav>

